#! /bin/bash
#check pcscd version 

pcscdfile=""

if [ -f /usr/sbin/pcscd ]; then
    pcscdfile=/usr/sbin/pcscd
else
    pcscdfile=`find /usr/local -type f -name pcscd | grep "/sbin/pcscd"`
fi

if [ "$pcscdfile" == "" ]; then
    exit 0
fi

vers=`$pcscdfile --version | awk '/version/ {print $3}'`
echo "pcscd version $vers"
v1=`echo "$vers" | awk 'BEGIN{FS="."}{print $1}'`
v2=`echo "$vers" | awk 'BEGIN{FS="."}{print $2}'`
v3=`echo "$vers" | awk 'BEGIN{FS="."}{print $3}'`

if [ "$v1" -gt 1 ];then
	exit 1
else
	if [ "$v2" -gt 7 ];then
		exit 1
	else
		if [ "$v3" -gt 4 ];then
			exit 1
		else
			exit 0
		fi
	fi
fi
