#!/bin/bash

JCPKCS_PACKAGE=`ls -l "$(dirname "$0")" | sed -r -n 's/.*(jcpkcs11-2_[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+_x64\.rpm)/\1/p'`
UC_PACKAGE=`ls -l "$(dirname "$0")" | sed -r -n 's/.*(jacartauc_[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+_x64\.rpm)/\1/p'`
cd "$(dirname "$0")"

if [ -z "RPM-ALADDIN.public.asc" ]; then
    echo "Ошибка!!! Отсутствует публичный ключ ОсОО \"Аладдин КГ\"!"
    exit 1
fi

if [ -z "$JCPKCS_PACKAGE" ]; then
    echo "Ошибка!!! Отсутствует пакет jcpkcs11-2!"
    exit 1
fi

if [ -z "$UC_PACKAGE" ]; then
    echo "Ошибка!!! Отсутствует пакет jacartauc!"
    exit 1
fi

if [ -f "/etc/altlinux-release" ]; then
    apt-get install -y libpcsclite pcsc-lite pcsc-lite-ccid libxkbcommon-x11
    apt-get install -y $JCPKCS_PACKAGE $UC_PACKAGE
    
else
    rpm --import RPM-ALADDIN.public.asc
    if [ $? -eq 0 ]; then
        echo -e "\e[32mThe public key has been successfully imported\e[0m"
    else
         echo -e "\e[31mError while importing the public key\e[0m"
    fi

    #Check yum or dnf
    if command -v yum >/dev/null; then
      yum install -y $JCPKCS_PACKAGE $UC_PACKAGE
    elif command -v dnf >/dev/null; then
      dnf install -y $JCPKCS_PACKAGE $UC_PACKAGE
    else
      echo "There isn't yum and dnf"
    fi
fi

#далее обрабатываются допустимые флаги установки
conf_file=/etc/xdg/AladdinKG/JCUC.conf
if [[ ! -f "$conf_file" && $# -gt 0 ]]; then
    mkdir -p $(dirname "$conf_file")
    sh -c "echo '[General]' > $conf_file"
fi

for i in "$@"; do
  case $i in
    --sys_tray_icon_visible=*)
      SYS_TRAY="${i#*=}"
      shift
      if [[ "$SYS_TRAY" == "no" ]]; then
        SYS_TRAY="sys-tray-icon-visible=false"
      elif [[ "$SYS_TRAY" == "yes" ]]; then
        SYS_TRAY="sys-tray-icon-visible=true"
      else
        SYS_TRAY=""
      fi
      if [[ -f "$conf_file" && $SYS_TRAY ]]; then
        line_number=$(grep -n "sys-tray-icon-visible" "$conf_file" | head -1 | cut -d':' -f1)
        if [[ $line_number > 0 ]]; then
          sed -i "${line_number}s/.*/$SYS_TRAY/" "$conf_file"
        else 
          line_number_general=$(grep -n '[General]' "$conf_file" | head -1 | cut -d':' -f1)
          if [[ $line_number_general > 0 ]]; then
            sed -i "${line_number_general}a ${SYS_TRAY}" "$conf_file"
          else
            sed -i '1i\'"$SYS_TRAY" "$conf_file"
          fi
        fi
      fi
      ;;
    --number_days_to_pin_expire=*)
      NUM_DAYS="${i#*=}"
      shift
      if [ -f "$conf_file" ] && [[ $NUM_DAYS =~ ^[0-9]+$ ]] && [[ $NUM_DAYS -ge 0 && $NUM_DAYS -le 365 ]]; then
        line_number=$(grep -n "number-days-to-pin-expire" "$conf_file" | head -1 | cut -d':' -f1)
        if [[ $line_number > 0 ]]; then
          ed -i "${line_number}s/.*/number-days-to-pin-expire=$NUM_DAYS/" "$conf_file"
        else 
          line_number_general=$(grep -n '[General]' "$conf_file" | head -1 | cut -d':' -f1)
          if [[ $line_number_general > 0 ]]; then
            sed -i "${line_number_general}a number-days-to-pin-expire=$NUM_DAYS" "$conf_file"
          else
            sed -i '1i\'"number-days-to-pin-expire=$NUM_DAYS" "$conf_file"
          fi
        fi
      fi
      ;;
    --certs_expiring_warning_visible=*)
      CERTS_EXPIRING="${i#*=}"
      shift
      if [[ "$CERTS_EXPIRING" == "no" ]]; then
        CERTS_EXPIRING="certs-expiring-warning-visible=false"
      elif [[ "$CERTS_EXPIRING" == "yes" ]]; then
        CERTS_EXPIRING="certs-expiring-warning-visible=true"
      else
        CERTS_EXPIRING=""
      fi
      if [[ -f "$conf_file" && $CERTS_EXPIRING ]]; then
        line_number=$(grep -n "certs-expiring-warning-visible" "$conf_file" | head -1 | cut -d':' -f1)
        if [[ $line_number > 0 ]]; then
          sed -i "${line_number}s/.*/$CERTS_EXPIRING/" "$conf_file"
        else 
          line_number_general=$(grep -n '[General]' "$conf_file" | head -1 | cut -d':' -f1)
          if [[ $line_number_general > 0 ]]; then
            sed -i "${line_number_general}a ${CERTS_EXPIRING}" "$conf_file"
          else
            sed -i '1i\'"$CERTS_EXPIRING" "$conf_file"
          fi
        fi
      fi
      ;; 
    --certs_expired_warning_visible=*)
      CERTS_EXPIRED="${i#*=}"
      shift
      if [[ "$CERTS_EXPIRED" == "no" ]]; then
        CERTS_EXPIRED="certs-expired-warning-visible=false"
      elif [[ "$CERTS_EXPIRED" == "yes" ]]; then
        CERTS_EXPIRED="certs-expired-warning-visible=true"
      else
        CERTS_EXPIRED=""
      fi
      if [[ -f "$conf_file" && $CERTS_EXPIRED ]]; then
        line_number=$(grep -n "certs-expired-warning-visible" "$conf_file" | head -1 | cut -d':' -f1)
        if [[ $line_number > 0 ]]; then
          sed -i "${line_number}s/.*/$CERTS_EXPIRED/" "$conf_file"
        else 
          line_number_general=$(grep -n '[General]' "$conf_file" | head -1 | cut -d':' -f1)
          if [[ $line_number_general > 0 ]]; then
            sed -i "${line_number_general}a ${CERTS_EXPIRED}" "$conf_file"
          else
            sed -i '1i\'"$CERTS_EXPIRED" "$conf_file"
          fi
        fi
      fi
      ;;
    --pin_expiration_as_dialog=*)
      PIN_DIALOG="${i#*=}"
      shift
      if [[ "$PIN_DIALOG" == "no" ]]; then
        PIN_DIALOG="pin-expiration-warning-display-as-dialog=false"
      elif [[ "$PIN_DIALOG" == "yes" ]]; then
        PIN_DIALOG="pin-expiration-warning-display-as-dialog=true"
      else
        PIN_DIALOG=""
      fi
      if [[ -f "$conf_file" && $PIN_DIALOG ]]; then
        line_number=$(grep -n "pin-expiration-warning-display-as-dialog" "$conf_file" | head -1 | cut -d':' -f1)
        if [[ $line_number > 0 ]]; then
          sed -i "${line_number}s/.*/$PIN_DIALOG/" "$conf_file"
        else 
          line_number_general=$(grep -n '[General]' "$conf_file" | head -1 | cut -d':' -f1)
          if [[ $line_number_general > 0 ]]; then
            sed -i "${line_number_general}a ${PIN_DIALOG}" "$conf_file"
          else
            sed -i '1i\'"$PIN_DIALOG" "$conf_file"
          fi
        fi
      fi
      ;;
  esac
done