#!/bin/bash

function log
{
    sev=$1
    msg=$2

    logger -p $sev -t $me $msg;
    echo "$me [$sev] $msg";
}

function log_err
{
    log user.error "$1" >&2;
}

function log_wrn
{
    log user.warning "$1" >&2;
}

function usage
{
    log_err "Invalid command line arguments or ccid_plist env variable not set";
    echo "$me <path to PS/SC ccid driver's Info.plist>";
}

function check_ccid_settings
{
    plist=$1

    while read LINE; do

        SECTION=`echo "$LINE" | sed -n 's/^.*<key>\(ifd[^ 	]*\)<\/key>.*$/\1/gp'`
        VALUES=`echo "$LINE" | sed -n 's/^.*<key>ifd[^ 	]*<\/key>[ 	]*<array>[ 	]*\(.*\)[ 	]*<\/array>.*$/\1/gp'`

        if [ -n "$VALUES"  ]; then
            SAVEIFS=$IFS
            IFS=$(echo -en "\n\b")
            VALUES=( `echo "$VALUES" | sed -n 's/[ 	]*<string>[ 	]*//gp' | sed -n 's/[ 	]*<\/string>[ 	]*/\n/gp' | sed '$d'` )
            IFS=$SAVEIFS

            if [ "$SECTION" == "ifdVendorID" ]; then
                IFDVENDORID=("${VALUES[@]}")
            fi

            if [ "$SECTION" == "ifdProductID" ];then
                IFDPRODUCTNAME=("${VALUES[@]}")
            fi

            if [ "$SECTION" == "ifdFriendlyName" ]; then
                IFDFRIENDLYNAME=("${VALUES[@]}")
            fi

        fi
    done < <(cat $plist | tr "\n" " " | tr "\r" " " |
             sed -n 's/\(.*\)/\1\n/gp' |
             sed -n 's/\(<key>ifd[^ 	]*<\/key>\)/\n\1/gp')

    COUNT=${#IFDVENDORID[@]}

    i=0
    while [ "$i" -le "$COUNT" ] ; do
        let i=i+1
        if [[ "${IFDVENDORID[$i]}" == "$VendorID" && "${IFDPRODUCTNAME[i]}" == "$ProductID" ]]; then
            log_wrn "No need to update any section"
            exit 0
        fi
    done

    echo "ifdVendorID ifdProductID ifdFriendlyName"
    exit 0

}

function update_ccid_settings
{
    need_to_insert=$2;
    plist=$1;
    awk_code="";
    for i in $need_to_insert; do
	case "$i" in
	'ifdVendorID')
	awk_code="$awk_code""/ifdVendorID/ {
	    skip=1;
	    print \"<array>\";
	    print \"<string>$VendorID</string>\";
	    next;
	    }"
	    ;;
	'ifdProductID')
	    awk_code=$awk_code"/ifdProductID/ {
	    skip=1;
	    print \"<array>\";
	    print \"<string>$ProductID</string>\";
	    next;
	    }"
	;;
	'ifdFriendlyName')
	awk_code="$awk_code""/ifdFriendlyName/ {
	    skip=1;
	    print \"<array>\"
	    print \"<string>$FriendlyName</string>\";
	    next;
	    }"
	;;
	esac
    done
    cat $plist | $Awk "BEGIN {skip=0} skip == 1 { skip=0; next }
	{print \$0}
	$awk_code"

    r=$?
    [ $r != 0 ] && log_err "Update sections to update $r" && exit $r;

    return $r;
}

me=`basename $0`
VendorID=$2
ProductID=$3
FriendlyName=$4

Plist="$ccid_plist" && [ ! -n "$Plist" ] && Plist=$1;
Awk=`which awk` && [ ! -n "$Awk" ] &&  Awk=`which gawk`;

[ ! -n "$Plist" ] && usage && exit 1;
[ ! -n "$Awk" ]   && log_err "awk(gawk) not found" && exit 2;

# log_wrn "vid:$VendorID pid:$ProductID fn:$FriendlyName";
need_to_insert=$(check_ccid_settings $Plist)
update_ccid_settings $Plist "${need_to_insert}";
r=$?;
[ $r == 0 ] || log_err "$Plist processing failed";

exit $r;
