#!/bin/bash
lncount=$(wc -l $1 | sed -e 's/ .*//')
if [[ $lncount = 0 ]]; then
    echo "$1 is empty."
    exit 2
fi
friendlyNameEntries=$(sed -n '/<key>ifdFriendlyName<\/key>/,/<\/array>/p' $1  | wc -l)
vendorIdEntries=$(sed -n '/<key>ifdVendorID<\/key>/,/<\/array>/p' $1  | wc -l)
productIdEntries=$(sed -n '/<key>ifdProductID<\/key>/,/<\/array>/p' $1  | wc -l)

#echo "product $productIdEntries; vendor $vendorIdEntries; friendly $friendlyNameEntries"
if [[ $productIdEntries = $vendorIdEntries && $vendorIdEntries = $friendlyNameEntries ]]; then
    exit 0
fi
echo "$1 has invalid structure. Entries by section: VendorID = $vendorIdEntries; ProductID = $productIdEntries; FriendlyName = $friendlyNameEntries"
exit 1
